package com.ejie.ab04b.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.ConstantesPlateaTramitacion;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.parse.MessageParser;
import com.ejie.ab04b.parse.MessageUnparser;
import com.ejie.app.xml.Applicant;
import com.ejie.ct.xml.Expedient;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.ct.xml.InfExpteList;
import com.ejie.ct.xml.Notice;
import com.ejie.ct.xml.NoticeList;
import com.ejie.ct.xml.NotificationAddress;
import com.ejie.ct.xml.Participant;
import com.ejie.mbt.xml.DescriptionType.Language;
import com.ejie.mbt.xml.NotifyTaskData;
import com.ejie.mbt.xml.PostalAddress;
import com.ejie.mbt.xml.Task;

/**
 * @author GFI-NORTE
 * 
 */
public final class PlateaTramitacionUtils {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(PlateaTramitacionUtils.class);

	private static PlateaTramitacionUtils instance;

	/**
	 * Constructor privado.
	 */
	private PlateaTramitacionUtils() {

	}

	/**
	 * Gets the single instance of PlateaTramitacionUtils.
	 * 
	 * ToolkitParameterUtils
	 *
	 * @return single instance of PlateaTramitacionUtils
	 */
	public static PlateaTramitacionUtils getInstance() {
		if (PlateaTramitacionUtils.instance == null) {
			PlateaTramitacionUtils.instance = new PlateaTramitacionUtils();
		}
		return PlateaTramitacionUtils.instance;
	}

	/**
	 * Devuelve un objeto T65BDocumentIDType a partir de su representación XML
	 * en String.
	 * 
	 * response String T65BDocumentIDType
	 *
	 * @param response
	 *            the response
	 * @return the platea response as task
	 */
	public Task getPlateaResponseAsTask(String response) {

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsTask", "INIT");

		Task obj = null;
		try {
			obj = (Task) new MessageParser<Task>(
					Task.class.getPackage().getName()).parse(response);
		} catch (Exception e) {
			PlateaTramitacionUtils.LOGGER.error(
					"getPlateaResponseAsTask - Error en el parseo del objeto response como Task");
		}

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsTask", "END");

		return obj;
	}

	/**
	 * Convierte un objeto Task a String.
	 * 
	 * task Task String
	 *
	 * @param task
	 *            the task
	 * @return the string
	 */
	public String unparseTaskToString(Task task) {

		try {
			MessageUnparser<Task> unparser = new MessageUnparser<Task>();
			return unparser.parse(task);
		} catch (Exception ioe) {
			return "";
		}
	}

	/**
	 * Convierte un objeto Applicant a String.
	 * 
	 * applicant Applicant String
	 *
	 * @param applicant
	 *            the applicant
	 * @return the string
	 */
	public String unparseApplicantToString(Applicant applicant) {

		try {
			MessageUnparser<Applicant> unparser = new MessageUnparser<Applicant>();
			return unparser.parse(applicant);
		} catch (Exception ioe) {
			return "";
		}
	}

	/**
	 * Devuelve un objeto Expedient a partir de su representación XML en String.
	 * 
	 * response String Expedient
	 *
	 * @param response
	 *            the response
	 * @return the platea response as expedient
	 */
	public Expedient getPlateaResponseAsExpedient(String response) {

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsExpedient",
				"INIT");

		Expedient obj = null;
		try {
			obj = (Expedient) new MessageParser<Expedient>(
					Expedient.class.getPackage().getName()).parse(response);
		} catch (Exception e) {
			PlateaTramitacionUtils.LOGGER.error(
					"getPlateaResponseAsExpedient - Error en el parseo del objeto response como Expedient");
		}

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsExpedient",
				"END");

		return obj;
	}

	/**
	 * Devuelve un objeto InfExpteList a partir de su representación XML en
	 * String.
	 * 
	 * response String InfExpteList
	 *
	 * @param response
	 *            the response
	 * @return the platea response as inf exp list
	 */
	public InfExpteList getPlateaResponseAsInfExpList(String response) {

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsInfExpList",
				"INIT");

		InfExpteList obj = null;
		try {
			obj = (InfExpteList) new MessageParser<InfExpteList>(
					InfExpteList.class.getPackage().getName()).parse(response);
		} catch (Exception e) {
			PlateaTramitacionUtils.LOGGER.error(
					"getPlateaResponseAsInfExpList - Error en el parseo del objeto response como InfExpteList");
		}

		PlateaTramitacionUtils.LOGGER.info("getPlateaResponseAsInfExpList",
				"END");

		return obj;
	}

	/**
	 * Devuelve un objeto InfExpteList a partir de su representación XML en
	 * String.
	 * 
	 * response String InfExpteList
	 *
	 * @param response
	 *            the response
	 * @return the platea response as folder document list
	 */
	public FolderDocumentList getPlateaResponseAsFolderDocumentList(
			String response) {

		PlateaTramitacionUtils.LOGGER
				.info("getPlateaResponseAsFolderDocumentList", "INIT");

		FolderDocumentList obj = null;
		try {
			obj = (FolderDocumentList) new MessageParser<FolderDocumentList>(
					FolderDocumentList.class.getPackage().getName())
							.parse(response);
		} catch (Exception e) {
			PlateaTramitacionUtils.LOGGER.error(
					"getPlateaResponseAsFolderDocumentList - Error en el parseo del objeto response como FolderDocumentList");
		}

		PlateaTramitacionUtils.LOGGER
				.info("getPlateaResponseAsFolderDocumentList", "END");

		return obj;
	}

	/**
	 * Construir mbt description type.
	 * 
	 * descEs String descEu String DescriptionType
	 *
	 * @param descEs
	 *            the desc es
	 * @param descEu
	 *            the desc eu
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType construirMbtDescriptionType(
			String descEs, String descEu) {

		com.ejie.mbt.xml.DescriptionType description = new com.ejie.mbt.xml.DescriptionType();
		description.getLanguage()
				.add(this.construirMbtLanguage(Constantes.ES, descEs));
		description.getLanguage()
				.add(this.construirMbtLanguage(Constantes.EU, descEu));
		return description;
	}

	/**
	 * Construir ainit description type.
	 * 
	 * descEs String descEu String DescriptionType
	 *
	 * @param descEs
	 *            the desc es
	 * @param descEu
	 *            the desc eu
	 * @return the com.ejie.ainit.xml. description type
	 */
	public com.ejie.ainit.xml.DescriptionType construirAinitDescriptionType(
			String descEs, String descEu) {

		com.ejie.ainit.xml.DescriptionType description = new com.ejie.ainit.xml.DescriptionType();
		description.getLanguage()
				.add(this.construirAinitLanguage(Constantes.ES, descEs));
		description.getLanguage()
				.add(this.construirAinitLanguage(Constantes.EU, descEu));
		return description;
	}

	/**
	 * Construir mbt language.
	 * 
	 * locale String value String Language
	 *
	 * @param locale
	 *            the locale
	 * @param value
	 *            the value
	 * @return the com.ejie.mbt.xml. description type. language
	 */
	public com.ejie.mbt.xml.DescriptionType.Language construirMbtLanguage(
			String locale, String value) {

		com.ejie.mbt.xml.DescriptionType.Language language = new com.ejie.mbt.xml.DescriptionType.Language();
		language.setLocale(locale);
		language.setValue(value);
		return language;
	}

	/**
	 * Construir ainit language.
	 * 
	 * locale String value String Language
	 *
	 * @param locale
	 *            the locale
	 * @param value
	 *            the value
	 * @return the com.ejie.ainit.xml. description type. language
	 */
	public com.ejie.ainit.xml.DescriptionType.Language construirAinitLanguage(
			String locale, String value) {

		com.ejie.ainit.xml.DescriptionType.Language language = new com.ejie.ainit.xml.DescriptionType.Language();
		language.setLocale(locale);
		language.setValue(value);
		return language;
	}

	/**
	 * Obtener entity name description.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerEntityNameDescription() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance().obtenerEntityName(Constantes.ES),
				Utilities.getInstance().obtenerEntityName(Constantes.EU));
	}

	/**
	 * Obtener organism name description.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerOrganismNameDescription() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance().obtenerOrganismName(Constantes.ES),
				Utilities.getInstance().obtenerOrganismName(Constantes.EU));
	}

	/**
	 * Obtener department name description.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerDepartmentNameDescription() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance().obtenerDepartmentName(Constantes.ES),
				Utilities.getInstance().obtenerDepartmentName(Constantes.EU));
	}

	/**
	 * Obtener managingunit name description.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerManagingunitNameDescription() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance().obtenerManagingunitName(Constantes.ES),
				Utilities.getInstance().obtenerManagingunitName(Constantes.EU));
	}

	/**
	 * Obtener organism name description osalan.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerOrganismNameDescriptionOsalan() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance()
						.obtenerOrganismNameOsalan(Constantes.ES),
				Utilities.getInstance()
						.obtenerOrganismNameOsalan(Constantes.EU));
	}

	/**
	 * Obtener department name description osalan.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerDepartmentNameDescriptionOsalan() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance()
						.obtenerDepartmentNameOsalan(Constantes.ES),
				Utilities.getInstance()
						.obtenerDepartmentNameOsalan(Constantes.EU));
	}

	/**
	 * Obtener managingunit name description osalan.
	 * 
	 * DescriptionType
	 *
	 * @return the com.ejie.mbt.xml. description type
	 */
	public com.ejie.mbt.xml.DescriptionType obtenerManagingunitNameDescriptionOsalan() {
		return this.construirMbtDescriptionType(
				Utilities.getInstance()
						.obtenerManagingunitNameOsalan(Constantes.ES),
				Utilities.getInstance()
						.obtenerManagingunitNameOsalan(Constantes.EU));
	}

	/**
	 * Construir document.
	 * 
	 * doc DocumentoAperturas Document
	 *
	 * @param doc
	 *            the doc
	 * @return the com.ejie.mbt.xml. document
	 */
	public com.ejie.mbt.xml.Document construirDocument(DocumentoAperturas doc) {

		com.ejie.mbt.xml.Document document = new com.ejie.mbt.xml.Document();

		document.setOid(doc.getOidDokusi065());
		document.setSourceName(doc.getNombreDoc065());
		document.setExtension(Utilities.getInstance()
				.obtenerExtensionFichero(doc.getNombreDoc065()));
		document.setRolID(doc.getTipoDocumento().getTipoDocumentalCompleto());
		document.setRolDescription(this.construirMbtDescriptionType(
				doc.getTipoDocumento().getDescripcionEs091(),
				doc.getTipoDocumento().getDescripcionEu091()));
		document.setDocumentDate(PlateaTramitacionUtils.getInstance()
				.formatearTimestampPlatea(doc.getFechaDoc065()));

		return document;
	}

	/**
	 * Construir document.
	 * 
	 * doc DocumentoAperturas Document
	 *
	 * @param doc
	 *            the doc
	 * @return the com.ejie.mbt.xml. document
	 */
	public com.ejie.mbt.xml.Document construirDocument(DocumentoOS2 doc) {

		com.ejie.mbt.xml.Document document = new com.ejie.mbt.xml.Document();

		document.setOid(doc.getOidDokusi094());
		document.setSourceName(doc.getNombreDoc094());
		document.setExtension(Utilities.getInstance()
				.obtenerExtensionFichero(doc.getNombreDoc094()));
		document.setRolID(doc.getTipoDocumento().getTipoDocumentalCompleto());
		document.setRolDescription(this.construirMbtDescriptionType(
				doc.getTipoDocumento().getDescripcionEs091(),
				doc.getTipoDocumento().getDescripcionEu091()));
		document.setDocumentDate(PlateaTramitacionUtils.getInstance()
				.formatearTimestampPlatea(doc.getFechaDoc094()));

		return document;
	}

	/**
	 * Construir document.
	 * 
	 * doc DocumentoOS3 Document
	 *
	 * @param doc
	 *            the doc
	 * @return the com.ejie.mbt.xml. document
	 */
	public com.ejie.mbt.xml.Document construirDocument(DocumentoOS3 doc) {

		com.ejie.mbt.xml.Document document = new com.ejie.mbt.xml.Document();

		document.setOid(doc.getOidDokusi097());
		document.setSourceName(doc.getNombreDoc097());
		document.setExtension(Utilities.getInstance()
				.obtenerExtensionFichero(doc.getNombreDoc097()));
		document.setRolID(doc.getTipoDocumento().getTipoDocumentalCompleto());
		document.setRolDescription(this.construirMbtDescriptionType(
				doc.getTipoDocumento().getDescripcionEs091(),
				doc.getTipoDocumento().getDescripcionEu091()));
		document.setDocumentDate(PlateaTramitacionUtils.getInstance()
				.formatearTimestampPlatea(doc.getFechaDoc097()));

		return document;
	}

	/**
	 * Parsear timestamp platea.
	 * 
	 * sdate String Date
	 *
	 * @param sdate
	 *            the sdate
	 * @return the date
	 */
	public Date parsearTimestampPlatea(String sdate) {
		DateFormat df = new SimpleDateFormat(
				ConstantesPlateaTramitacion.PLATEA_XML_EVENTS_DATE_FORMAT);
		try {
			return df.parse(sdate);
		} catch (ParseException pe) {
			return null;
		}
	}

	/**
	 * Formatear timestamp platea.
	 * 
	 * date Date String
	 *
	 * @param date
	 *            the date
	 * @return the string
	 */
	public String formatearTimestampPlatea(Date date) {
		DateFormat df = new SimpleDateFormat(
				ConstantesPlateaTramitacion.PLATEA_XML_EVENTS_DATE_FORMAT);

		return df.format(date);
	}

	/**
	 * Obtener notification format.
	 * 
	 * canalNotificacion String String
	 *
	 * @param canalNotificacion
	 *            the canal notificacion
	 * @return the string
	 */
	public String obtenerNotificationFormat(String canalNotificacion) {
		if (Constantes.CANAL_NOTIF_POSTAL.equals(canalNotificacion)) {
			return ConstantesPlateaTramitacion.CS_TIPO_NOTIF_POSTAL;
		} else if (Constantes.CANAL_NOTIF_TELEMATICO
				.equals(canalNotificacion)) {
			return ConstantesPlateaTramitacion.CS_TIPO_NOTIF_ELECTRONICA;
		}
		return "";
	}

	/**
	 * Obtener notification language.
	 * 
	 * idiomaNotificacion String String
	 *
	 * @param idiomaNotificacion
	 *            the idioma notificacion
	 * @return the string
	 */
	public String obtenerNotificationLanguage(String idiomaNotificacion) {
		if (Constantes.IDIOMA_NOTIF_CASTELLANO.equals(idiomaNotificacion)) {
			return ConstantesPlateaTramitacion.IDIOMA_NOTIF_CASTELLANO;
		} else if (Constantes.IDIOMA_NOTIF_EUSKERA.equals(idiomaNotificacion)) {
			return ConstantesPlateaTramitacion.IDIOMA_NOTIF_EUSKERA;
		}
		return "";
	}

	/**
	 * Obtener canal notificacion.
	 * 
	 * notificationFormat String String
	 *
	 * @param notificationFormat
	 *            the notification format
	 * @return the string
	 */
	public String obtenerCanalNotificacion(String notificationFormat) {
		if (ConstantesPlateaTramitacion.CS_TIPO_NOTIF_POSTAL
				.equals(notificationFormat)) {
			return Constantes.CANAL_NOTIF_POSTAL;
		} else if (ConstantesPlateaTramitacion.CS_TIPO_NOTIF_ELECTRONICA
				.equals(notificationFormat)) {
			return Constantes.CANAL_NOTIF_TELEMATICO;
		}
		return "";
	}

	/**
	 * Obtener idioma notificacion.
	 * 
	 * notificationLanguage String String
	 *
	 * @param notificationLanguage
	 *            the notification language
	 * @return the string
	 */
	public String obtenerIdiomaNotificacion(String notificationLanguage) {
		if (ConstantesPlateaTramitacion.IDIOMA_NOTIF_CASTELLANO
				.equals(notificationLanguage)) {
			return Constantes.IDIOMA_NOTIF_CASTELLANO;
		} else if (ConstantesPlateaTramitacion.IDIOMA_NOTIF_EUSKERA
				.equals(notificationLanguage)) {
			return Constantes.IDIOMA_NOTIF_EUSKERA;
		}
		return "";
	}

	/**
	 * Obtener tipo documento context submission.
	 * 
	 * personType String String
	 *
	 * @param personType
	 *            the person type
	 * @return the string
	 */
	public String obtenerTipoDocumentoContextSubmission(String personType) {
		if (ConstantesPlateaTramitacion.CS_PERSONTYPE_FISICA
				.equals(personType)) {
			return Constantes.TIPO_NIF;
		} else if (ConstantesPlateaTramitacion.CS_PERSONTYPE_JURIDICA
				.equals(personType)) {
			return Constantes.TIPO_CIF;
		}
		return "";
	}

	/**
	 * Obtener person type context submission.
	 * 
	 * tipoDoc String String
	 *
	 * @param tipoDoc
	 *            the tipo doc
	 * @return the string
	 */
	public String obtenerPersonTypeContextSubmission(String tipoDoc) {
		if (Constantes.TIPO_CIF.equals(tipoDoc)) {
			return ConstantesPlateaTramitacion.CS_PERSONTYPE_JURIDICA;
		}
		return ConstantesPlateaTramitacion.CS_PERSONTYPE_FISICA;
	}

	/**
	 * Obtener person type context submission from num doc.
	 * 
	 * numDoc String String
	 *
	 * @param numDoc
	 *            the num doc
	 * @return the string
	 */
	public String obtenerPersonTypeContextSubmissionFromNumDoc(String numDoc) {
		if (ValidadorNifCifNie.checkCif(numDoc)) {
			return ConstantesPlateaTramitacion.CS_PERSONTYPE_JURIDICA;
		}
		return ConstantesPlateaTramitacion.CS_PERSONTYPE_FISICA;
	}

	/**
	 * Obtener tipo aviso context submission.
	 * 
	 * channelType String Integer
	 *
	 * @param channelType
	 *            the channel type
	 * @return the integer
	 */
	public Integer obtenerTipoAvisoContextSubmission(String channelType) {
		if (ConstantesPlateaTramitacion.CS_TIPO_AVISO_EMAIL
				.equals(channelType)) {
			return Constantes.CANAL_AVISO_EMAIL;
		} else if (ConstantesPlateaTramitacion.CS_TIPO_AVISO_SMS
				.equals(channelType)) {
			return Constantes.CANAL_AVISO_SMS;
		}
		return null;
	}

	/**
	 * Obtener notification channel type.
	 * 
	 * canalAviso Integer String
	 *
	 * @param canalAviso
	 *            the canal aviso
	 * @return the string
	 */
	public String obtenerNotificationChannelType(Integer canalAviso) {
		if (Constantes.CANAL_AVISO_EMAIL.equals(canalAviso)) {
			return ConstantesPlateaTramitacion.CS_TIPO_AVISO_EMAIL;
		} else if (Constantes.CANAL_AVISO_SMS.equals(canalAviso)) {
			return ConstantesPlateaTramitacion.CS_TIPO_AVISO_SMS;
		}
		return null;
	}

	/**
	 * Rellenar datos basicos notification.
	 * 
	 * notifyTaskData NotifyTaskData datosNotif DatosNotificacion addresseeId
	 * String addresseeName String NotifyTaskData
	 *
	 * @param notifyTaskData
	 *            the notify task data
	 * @param datosNotif
	 *            the datos notif
	 * @param addresseeId
	 *            the addressee id
	 * @param addresseeName
	 *            the addressee name
	 * @return the notify task data
	 */
	public NotifyTaskData rellenarDatosBasicosNotification(
			NotifyTaskData notifyTaskData, DatosNotificacion datosNotif,
			String addresseeId, String addresseeName) {

		notifyTaskData
				.setOrganizationID(Utilities.getInstance().obtenerEntityId());
		notifyTaskData.setOrganizationName(PlateaTramitacionUtils.getInstance()
				.obtenerEntityNameDescription());

		notifyTaskData
				.setSignType(ConstantesPlateaTramitacion.TIPO_FIRMA_SERVIDOR);
		notifyTaskData.setCertInstance(
				PropertiesUtil.getProperty(PropertiesUtil.CERT_INSTANCE));

		notifyTaskData.setNotificationLanguage(PlateaTramitacionUtils
				.getInstance()
				.obtenerNotificationLanguage(datosNotif.getIdioma066()));
		notifyTaskData.setNotificationFormat(
				PlateaTramitacionUtils.getInstance().obtenerNotificationFormat(
						datosNotif.getCanalnotif066()));

		notifyTaskData.setAddresseeID(addresseeId);
		notifyTaskData.setAddresseeName(addresseeName);

		return notifyTaskData;
	}

	/**
	 * Obtiene el código Nora del valor recibido en el context submission El
	 * código Nora viene entre paréntesis, p.e.
	 * <localidad>(10105900000734)Vitoria-Gasteiz</localidad>
	 * 
	 * value String String
	 *
	 * @param value
	 *            the value
	 * @return the string
	 */
	public String obtenerCodigoNoraContextSubmissionChannelInfo(String value) {

		return value.substring(value.indexOf("(") + 1, value.indexOf(")"));
	}

	/**
	 * Construye el el valor de un dato Nora. El código Nora viene entre
	 * paréntesis, p.e. <localidad>(10105900000734)Vitoria-Gasteiz</localidad>
	 * 
	 * value String descripcion String String
	 *
	 * @param value
	 *            the value
	 * @param descripcion
	 *            the descripcion
	 * @return the string
	 */
	public String construirValorNoraContextSubmissionChannelInfo(String value,
			String descripcion) {

		StringBuilder sb = new StringBuilder();
		sb.append("(");
		sb.append(value);
		sb.append(")");
		sb.append(descripcion);
		return sb.toString();
	}

	/**
	 * Obtiene la descripción de un expediente antiguo con códigos FCA Obviamos
	 * el código y devolvemos únicamente la descripción.
	 * 
	 * value String String
	 *
	 * @param value
	 *            the value
	 * @return the string
	 */
	public String obtenerDescripcionFCAFolderInfo(String value) {

		int indexParentClose = value.indexOf(")");
		if (indexParentClose != -1) {
			return value.substring(indexParentClose + 1);
		}
		return value;
	}

	/**
	 * Construir datos notificacion from participant.
	 * 
	 * participant Participant esMigrado boolean DatosNotificacion
	 *
	 * @param participant
	 *            the participant
	 * @param esMigrado
	 *            the es migrado
	 * @return the datos notificacion
	 */
	public DatosNotificacion construirDatosNotificacionFromParticipant(
			Participant participant, boolean esMigrado) {

		NotificationAddress notificationAddress = participant
				.getNotificationAddress();
		NoticeList noticeList = participant.getNoticeList();

		DatosNotificacion datosNotificacion = new DatosNotificacion();
		datosNotificacion.setCanalnotif066(PlateaTramitacionUtils.getInstance()
				.obtenerCanalNotificacion(notificationAddress.getChanelType()));
		datosNotificacion.setIdioma066(PlateaTramitacionUtils.getInstance()
				.obtenerIdiomaNotificacion(participant.getLanguage()));

		if (Constantes.CANAL_NOTIF_POSTAL
				.equals(datosNotificacion.getCanalnotif066())) {
			// Si es canal notificación postal, obtenemos datos de localización

			DatosLocalizacion datosLocalizacion = new DatosLocalizacion();

			// Obtenemos el objeto <chanelInfo
			// xmlns="com/ejie/ct/xml"><postalAddress>...
			Node nodeChannelInfo = (Node) notificationAddress.getChanelInfo();
			// Parseamos el primer hijo para quedarnos con <postalAddress>
			String sNodeChannelInfo = XmlUtils
					.parseDocument2String(nodeChannelInfo.getFirstChild());
			// Cambiamos el namespace ct por mbt para parsear
			sNodeChannelInfo = sNodeChannelInfo.replace(
					"xmlns=\"com/ejie/ct/xml\"", "xmlns=\"com/ejie/mbt/xml\"");

			PostalAddress postalAddress = this
					.getChannelInfoAsPostalAddress(sNodeChannelInfo);

			// Si no es migrado, los códigos Nora vienen entre paréntesis
			try {
				if (postalAddress.getProvincia().getLanguage().get(0).getValue()
						.indexOf("(") != -1) {
					datosLocalizacion
							.setProvincia(new Provincia(StringUtils.leftPad(
									this.obtenerCodigoNoraContextSubmissionChannelInfo(
											this.obtenerDescripcionIdiomaFromListLanguage(
													postalAddress.getProvincia()
															.getLanguage(),
													Constantes.ES)),
									ConstantesNum.NUM_2, "0")

					));
				} else {
					String desc = "";
					desc = this.obtenerDescripcionIdiomaFromListLanguage(
							postalAddress.getProvincia().getLanguage(),
							Constantes.EU);
					if (desc != null && !desc.equals("")) {
						this.obtenerDescripcionIdiomaFromListLanguage(
								postalAddress.getProvincia().getLanguage(),
								Constantes.ES);
					}
					datosLocalizacion
							.setProvincia(new Provincia(null, desc, null));
				}
			} catch (Exception e) {
				PlateaTramitacionUtils.LOGGER.error(
						"Error en construirDatosNotificacionFromParticipant",
						e);
			}
			try {
				if (postalAddress.getMunicipio().indexOf("(") != -1) {
					datosLocalizacion.setMunicipio(
							new Municipio(StringUtils.leftPad(
									this.obtenerCodigoNoraContextSubmissionChannelInfo(
											postalAddress.getMunicipio()),
									ConstantesNum.NUM_3, "0")));
				} else {
					datosLocalizacion.setMunicipio(new Municipio(null, null,
							postalAddress.getMunicipio()));
				}
			} catch (Exception e) {
				PlateaTramitacionUtils.LOGGER.error(
						"Error en construirDatosNotificacionFromParticipant",
						e);
			}

			if (null != postalAddress.getLocalidad()
					&& postalAddress.getLocalidad().indexOf("(") != -1) {
				this.obtenerCodigoNoraContextSubmissionChannelInfo(
						postalAddress.getLocalidad());
				datosLocalizacion.setLocalidad(new Localidad(
						this.obtenerCodigoNoraContextSubmissionChannelInfo(
								postalAddress.getLocalidad())));
			} else {
				datosLocalizacion.setLocalidad(new Localidad(null, null, null,
						this.obtenerDescripcionFCAFolderInfo(
								postalAddress.getLocalidad())));
			}

			datosLocalizacion.setCalle067(postalAddress.getDireccion());
			datosLocalizacion.setPortal067(postalAddress.getPortal());
			datosLocalizacion.setPiso067(postalAddress.getPiso());
			datosLocalizacion.setPuerta067(postalAddress.getLetra());
			datosLocalizacion.setCodpostal067(postalAddress.getCp());

			datosNotificacion.setDatosLocalizacion(datosLocalizacion);
		}

		List<DatosAviso> listaDatosAviso = new ArrayList<DatosAviso>();
		if (noticeList != null && noticeList.getNotice() != null
				&& !noticeList.getNotice().isEmpty()) {
			for (Notice notice : noticeList.getNotice()) {
				DatosAviso datosAviso = new DatosAviso();

				// Obtenemos el atributo getChannelInfoType donde está el sms o
				// e-mail
				Node nodeChannelInfoType = (Node) notice.getChannelInfoType();

				datosAviso.setTipo068(PlateaTramitacionUtils.getInstance()
						.obtenerTipoAvisoContextSubmission(
								notice.getChanelType()));
				datosAviso.setValor068(nodeChannelInfoType.getFirstChild()
						.getFirstChild().getNodeValue());
				listaDatosAviso.add(datosAviso);
			}
		}
		datosNotificacion.setListaDatosAviso(listaDatosAviso);

		return datosNotificacion;

	}

	/**
	 * Obtener descripcion idioma from list language.
	 * 
	 * listLanguage List<Language> idioma String en formato Platea ("es" o "eu")
	 * String
	 *
	 * @param listLanguage
	 *            the list language
	 * @param idioma
	 *            the idioma
	 * @return the string
	 */
	public String obtenerDescripcionIdiomaFromListLanguage(
			List<Language> listLanguage, String idioma) {

		if (listLanguage != null && !listLanguage.isEmpty()) {
			for (Language language : listLanguage) {
				if (language.getLocale().equals(idioma)) {
					return language.getValue();
				}
			}
		}
		return "";
	}

	/**
	 * Devuelve un objeto PostalAddress a partir channelInfo.
	 * 
	 * node String PostalAddress
	 *
	 * @param node
	 *            the node
	 * @return the channel info as postal address
	 */
	public PostalAddress getChannelInfoAsPostalAddress(String node) {

		PlateaTramitacionUtils.LOGGER.info("getChannelInfoAsPostalAddress",
				"INIT");

		PostalAddress obj = null;
		try {
			obj = (PostalAddress) new MessageParser<PostalAddress>(
					PostalAddress.class.getPackage().getName()).parse(node);
		} catch (Exception e) {
			PlateaTramitacionUtils.LOGGER.error(
					"getChannelInfoAsPostalAddress - Error en el parseo del objeto node como PostalAddress");
		}

		PlateaTramitacionUtils.LOGGER.info("getChannelInfoAsPostalAddress",
				"END");

		return obj;
	}

}
